import pandas as pd   
import matplotlib.pyplot as plt
   
# Load the dataset   
credit_customers = pd.read_csv("credit_customers.csv")   
  
# Plot pie charts   
fig, axes = plt.subplots(1, 3, figsize=(18, 6))   
   
approval_rates_middle_aged.plot(kind='pie', ax=axes[0], autopct='%.1f%%', startangle=90, ylabel='')   
axes[0].set_title('Loan Approval Rates for Middle-Aged Customers (40-59)')   

approval_rates_stable_employment.plot(kind='pie', ax=axes[1], autopct='%.1f%%', startangle=90, ylabel='')   
axes[1].set_title('Loan Approval Rates for Customers with Stable Employment')   

approval_rates_good_credit_history.plot(kind='pie', ax=axes[2], autopct='%.1f%%', startangle=90, ylabel='')   
axes[2].set_title('Loan Approval Rates for Customers with Good/Excellent Credit History')   

plt.tight_layout()   
plt.savefig('ref_result/pieplot.png') 
plt.show()   

  